﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class OrdersPaymentBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static OrdersPayment GetItem(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate, bool isOffline = false)
        {
            return OrdersPaymentDB.GetItem(ordersPaymentID, ordersID, fromDate, endDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<OrdersPayment> GetList(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate, bool isOffline = false)
        {
            return OrdersPaymentDB.GetList(ordersPaymentID, ordersID, fromDate, endDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate)
        {
            return OrdersPaymentDB.GetDataTable(ordersPaymentID, ordersID, fromDate, endDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate)
        {
            return OrdersPaymentDB.GetDataSet(ordersPaymentID, ordersID, fromDate, endDate);
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(OrdersPayment myOrdersPayment, bool isOffline = false)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                OrdersPaymentDB.Save(myOrdersPayment);
                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
